/*
 * Lets the navigation indicator return to the currently active element.
 * 

 */
function simplegeometryReleaseNav(wrapper) {
	var indicator = jQuery(wrapper).find('.nav-menu-position');
	var newLeft = '' + jQuery(wrapper).find('.cm_current').position().left + 'px';
	var newWidth = '' + jQuery(wrapper).find('.cm_current').width() + 'px';
	
	jQuery(indicator).stop(true, false).animate({left: newLeft, width: newWidth});
}

/*
 * Lets the navigation indicator slide to the hovered element.
 * 
 */
function simplegeometryHighlightNav(navElement) {
	var wrapper = jQuery(navElement).closest('#navigation_wrapper');
	var indicator = jQuery(wrapper).find('.nav-menu-position');
	var newLeft = '' + jQuery(navElement).position().left + 'px';
	var newWidth = '' + jQuery(navElement).width() + 'px';
	
	if (jQuery(indicator).css('display') != 'none') {
		jQuery(indicator).stop(true, false).animate({left: newLeft, width: newWidth}, 250, 'swing', function(){
			jQuery('#cm_navigation>ul>li.cm_has_subnavigation:hover>ul').slideDown(150);
			edgeRecalculate(jQuery('#cm_navigation>ul>li.cm_has_subnavigation:hover>ul>li:last-child'));
		});
	} else {
		jQuery(navElement).children('ul').slideDown(150);
	}
}

/*
 * Lets the navigation indicator return to the currently active element.
 * 
 */
function simplegeometryInitialiseNav(wrapper) {
	
		
	var indicator = jQuery(wrapper).find('.nav-menu-position');
	var current = jQuery(wrapper).find('.cm_current');
	if(current.length){
		var newLeft = '' + jQuery(wrapper).find('.cm_current').position().left + 'px';
		var newWidth = '' + jQuery(wrapper).find('.cm_current').width() + 'px';
		
		jQuery(indicator).css({left: newLeft, width: newWidth});
	}
}

/*
 * Initialise the indicator animation.
 * 
 */
jQuery(document).ready(function(){
	jQuery('#nav-mobile-heading > a').html(jQuery('#cm_navigation li.cm_current>a').html());
	jQuery('#navigation_wrapper').each(function(){
		simplegeometryInitialiseNav(this);
		jQuery(this).mouseleave(function(){
			simplegeometryReleaseNav(this);
		});
	});
	jQuery('#cm_navigation>ul>li').each(function(){
		jQuery(this).mouseenter(
			function() {
				simplegeometryHighlightNav(this);
			}
		);
	});
});